/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.base.PathUtils;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.adaptors.jms.VWResolver;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class OASHelper {
    protected static final String m_className = "OASHelper";
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    private static boolean bNeed2DeleteFile = true;
    private static String APPCLIENT_XML_TEMPLATE = "<application-client><resource-ref><res-ref-name>{0}</res-ref-name><res-type>javax.jms.QueueConnectionFactory</res-type><res-auth>Container</res-auth></resource-ref><resource-ref><res-ref-name>{1}</res-ref-name><res-type>javax.jms.Queue</res-type><res-auth>Container</res-auth></resource-ref></application-client>";
    private static final String OAS_PREFIX = "java:comp/env/jms/";

    private static String getCurrentPathNameForApplicationClientXML() {
        String m_method = "getCurrentPath";
        try {
            PathUtils p = new PathUtils();
            String s = p.getResourceLocation("META-INF" + File.separator + "application-client.xml");
            if (logger.isFinest()) {
                logger.finest(m_className, "getCurrentPath", "Found META-INF/application-client.xml at " + s);
            }
            return s;
        }
        catch (Throwable t) {
            if (logger.isFinest()) {
                logger.finest(m_className, "getCurrentPath", t.getLocalizedMessage());
            }
            return null;
        }
    }

    private static File[] getDirectoriesInClassPath() throws Exception {
        String myPath = System.getProperty("java.class.path");
        if (myPath == null) {
            return null;
        }
        String m_method = "getDirectoriesInClassPath";
        if (logger.isFinest()) {
            logger.finest(m_className, "getDirectoriesInClassPath", "Examining path=" + myPath);
        }
        Vector<Object> v = new Vector<Object>(1);
        StringTokenizer stmp = new StringTokenizer(myPath, File.pathSeparator);
        String token = myPath;
        if (stmp.countTokens() > 0) {
            while (stmp.hasMoreTokens()) {
                File aFile;
                token = stmp.nextToken();
                if (token != null) {
                    token = token.trim();
                }
                if (token == null || token.length() <= 0 || !(aFile = new File(token)).isDirectory() || v.contains(aFile) || aFile.getCanonicalPath().endsWith("WEB-INF")) continue;
                v.add(aFile);
            }
        } else {
            v.add(myPath);
        }
        if (v.size() == 0) {
            return null;
        }
        return v.toArray(new File[0]);
    }

    private static void create_application_client_XML(String qCF, String qName, File parentDir) throws Exception {
        String m_method = "create_application_client_XML" + qCF + "," + qName + "," + parentDir.getCanonicalPath();
        try {
            boolean ok;
            File META_INF_DIR = new File(parentDir, "META-INF");
            if (!META_INF_DIR.exists()) {
                if (!META_INF_DIR.mkdirs()) {
                    logger.warning(m_className, m_method, "Failed to create" + META_INF_DIR.getCanonicalPath());
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Created " + META_INF_DIR.getCanonicalPath());
                }
            }
            boolean bl = ok = META_INF_DIR.exists() && META_INF_DIR.isDirectory();
            if (ok) {
                OASHelper.createFileInDir(qCF, qName, META_INF_DIR);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        logger.exiting(m_className, m_method);
    }

    private static void checkNode(VWXMLWrapper xmlWrapper, String res_ref_name, String res_ref_type) {
        String m_method = "checkNode:" + res_ref_name + "," + res_ref_type;
        Node[] resource_refs = VWXMLWrapper.getNodesNamed(xmlWrapper.getRootNode(), "resource-ref");
        int nRes = resource_refs == null ? 0 : resource_refs.length;
        for (int i = 0; i < nRes; ++i) {
            Node r = resource_refs[i];
            String s = VWXMLWrapper.getNodeValue(r, "res-ref-name");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "res-ref-name[" + Integer.toString(i) + "]=" + s);
            }
            if (s == null || !s.equals(res_ref_name)) continue;
            String t = VWXMLWrapper.getNodeValue(r, "res-type");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "res-type[" + Integer.toString(i) + "]=" + t);
            }
            if (t != null && t.equals(res_ref_type)) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Not adding");
                }
                return;
            }
            logger.warning(m_className, m_method, "Got a res-ref-name " + s + " that has res-type=" + t + " instead of " + res_ref_type);
            return;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "adding");
        }
        Node QCFResourceRefNode = xmlWrapper.createNodeNamed(xmlWrapper.getRootNode(), "resource-ref", null);
        xmlWrapper.createNodeNamed(QCFResourceRefNode, "res-ref-name", res_ref_name);
        xmlWrapper.createNodeNamed(QCFResourceRefNode, "res-type", res_ref_type);
        xmlWrapper.createNodeNamed(QCFResourceRefNode, "res-auth", "Container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileInDir(String qCF, String qName, File parentDir) throws Exception, FileNotFoundException, IOException {
        String m_method = "createFileInDir:" + qCF + "," + qName + "," + parentDir.getCanonicalPath();
        logger.entering(m_className, m_method);
        File appFile = new File(parentDir, "application-client.xml");
        String s = null;
        if (appFile.exists()) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Found an existing one..");
            }
            VWXMLWrapper xmlWrapper = new VWXMLWrapper(new FileInputStream(appFile), (EntityResolver)new VWResolver());
            OASHelper.checkNode(xmlWrapper, qCF, "javax.jms.QueueConnectionFactory");
            OASHelper.checkNode(xmlWrapper, qName, "javax.jms.Queue");
            s = xmlWrapper.toString();
        } else {
            s = MessageFormat.format(APPCLIENT_XML_TEMPLATE, qCF, qName);
        }
        s = VWStringUtils.xmlPrettyFormat(s);
        FileWriter w = null;
        try {
            w = new FileWriter(appFile);
            w.write(s);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception e) {}
            }
        }
        if (bNeed2DeleteFile && logger.isFinest()) {
            logger.finest(m_className, m_method, "marked filed to be deleted on exit");
        }
        logger.exiting(m_className, m_method);
    }

    protected static void OC4JJMS_create_application_client_XML(String qCF, String qName) throws Exception {
        String curName;
        String m_method = "OC4JJMS_create_application_client_XML";
        if (qCF == null || qName == null) {
            return;
        }
        qCF = qCF.trim();
        qName = qName.trim();
        if (qCF.length() == 0 || qName.length() == 0) {
            return;
        }
        logger.entering(m_className, "OC4JJMS_create_application_client_XML");
        if (qCF.indexOf(OAS_PREFIX) == 0) {
            qCF = "jms/" + qCF.substring(OAS_PREFIX.length());
        }
        if (qName.indexOf(OAS_PREFIX) == 0) {
            qName = "jms/" + qName.substring(OAS_PREFIX.length());
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "OC4JJMS_create_application_client_XML", qCF + "," + qName);
        }
        if ((curName = OASHelper.getCurrentPathNameForApplicationClientXML()) == null) {
            File[] dirs = OASHelper.getDirectoriesInClassPath();
            if (dirs == null || dirs.length == 0) {
                return;
            }
            File parentDir = dirs[0];
            OASHelper.create_application_client_XML(qCF, qName, parentDir);
        } else {
            String classpath;
            if (logger.isFinest()) {
                logger.finest(m_className, "OC4JJMS_create_application_client_XML", "Got " + curName);
            }
            if ((classpath = System.getProperty("java.class.path")).indexOf(curName) >= 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "OC4JJMS_create_application_client_XML", "it's from a jar file!");
                }
            } else {
                File parentDir = new File(curName).getParentFile();
                OASHelper.createFileInDir(qCF, qName, parentDir);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 2) {
                OASHelper.OC4JJMS_create_application_client_XML(args[0], args[1]);
            } else {
                OASHelper.OC4JJMS_create_application_client_XML("java:comp/env/jms/MyQCF", "java:comp/env/jms/MyQ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

